require 'json'
require 'watir-webdriver'
require 'page-object'
require 'httparty'
require 'open3'
require_relative '../spec/rspec_helper'


class CancelAppointment < Hash

  def initialize(kind, site, patientID)
    body = get_appointment_kind_obj(kind)
    attrs = JSON.parse(body)
    attrs = deep_copy(attrs)

    attrs[0].each do |k, v|
      self[k] = v
    end

    @jwt_url = VAR_SERVICE_URL + 'jwt'
    @site = site
    @patient_id = patientID

    @JWT
    #@path = "#{VAR_SERVICE_URL}var/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/523/patient/ICN/#{@patient_id}/cancel-appointment"
    @path = "#{VAR_SERVICE_URL}var/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/#{@site}/patient/ICN/#{@patient_id}/cancel-appointment"
  end

  def getAuthCookie
    curl_command = `curl --silent '#{@jwt_url}' -H 'va_eauth_icn: #{@patient_id}' --insecure 2>&1`
    return curl_command.delete(' ')
  end

  def read_file(fileName)
    path=File.expand_path('../../module/database/snapshots/'+fileName, __FILE__)
    file = File.open(path, "r")
    contents = file.read
    return contents
  end

  def deep_copy(obj)
    Marshal.load(Marshal.dump(obj))
  end

  def get_appointment_kind_obj(kind)
    case kind
      when "CLINIC_BASED_BOSTON"
        p "appointmentKind = CLINIC_BASED"
        fileName = "cancel.json"
      else
        fail "****** Please define this appointment Kind in your code ******"
    end
    return read_file(fileName)
  end

  #def cancel_appointment(objectType, dateTime)
  def cancel_appointment()
    #self.update_appointment_obj(objectType, dateTime)
    @JWT = getAuthCookie
    response = put_app(@path, self, @JWT)
    fail "Could not cancel appointment. Please clean your data base and try again.\nResponse body:\n#{response.body}" unless (response.code == 200 || response.body.include?("Appointment already cancelled"))
  end

  def update_appointment_obj(name_to_update, new_value)
    self[name_to_update] = new_value
    return self
  end

  def post_app(path, body)
    body = body.to_json
    directory = HTTParty.post(path, { :body => body, :headers => { 'Content-Type' => 'application/json'}})
    return directory
  end

  def put_app(path, body, jwt)
    body = body.to_json
    directory = HTTParty.put(path, { :body => body, :headers => { 'accept' => 'application/json', 'Content-Type' => 'application/json', 'x-vamf-jwt' =>"#{jwt}"}})
    return directory
  end


end